<%@ page import="java.util.*, java.sql.*, java.util.ArrayList" %>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ page import="ibase.utility.UserInfoBean, ibase.webitm.ejb.vhb.msq1.ApprovedRate" %>

<%
    System.out.println("@@@@@@@@ In ApprovedRate.jsp @@@@@@@@@@@@@@@@");
    UserInfoBean userInfo = (UserInfoBean) session.getAttribute("USER_INFO");

    if (userInfo == null) {
        out.print("<p style='color:red;'>Invalid session. Please log in.</p>");
        return;
    }

    String itemCode = request.getParameter("ITEM_CODE") != null ? request.getParameter("ITEM_CODE") : "";

    if (itemCode.trim().isEmpty()) {
        out.print("<p style='color:red;'>Item code is missing.</p>");
        return;
    }

    System.out.println("@@@@@@@@ ITEM_CODE: " + itemCode);
    HashMap<String, ArrayList<String>> approvedMap = null;

    try {
        ApprovedRate approvedRate = new ApprovedRate(userInfo);
        approvedMap = approvedRate.getLastThreeQuotationRates(itemCode);
        System.out.println("approvedMap: " + approvedMap);
    } catch (Exception e) {
        e.printStackTrace();
        out.print("<p style='color:red;'>Error retrieving approved quotation details: " + e.getMessage() + "</p>");
        return;
    }
%>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Approved Quotation Details</title>
    <link type="text/css" rel="stylesheet" href="/ibase/webitm/css/sidePanelDisplay.css">
</head>
<body>

<h2>Approved Quotation Details</h2>

<form>
    <table border="1" class="itemtbl">
        <tr>
            <th>Customer Code</th>
            <th>Quotation No</th>
            <th>Quotation Date</th>
            <th>Item Code</th>
            <th>Approved Rate</th>
        </tr>
        <%
            if (approvedMap != null && !approvedMap.isEmpty()) {
                for (Map.Entry<String, ArrayList<String>> entry : approvedMap.entrySet()) {
                    ArrayList<String> values = entry.getValue();
        %>
        <tr>
            <% for (String value : values) { %>
                <td><%= value %></td>
            <% } %>
        </tr>
        <%
                }
            } else {
        %>
        <tr>
            <td colspan="5" style="color:red; text-align: center;">
                No approved quotations found for the selected item code.
            </td>
        </tr>
        <% } %>
    </table>
</form>

</body>
</html>

